//Lab 3 : Plot the time-responses of the second-order systems with 
//various damping factors.
//------------------------------------------------------------------
// Problem Statement: Compare Step response of G=1/(s^2+2*xi*wn*s+wn^2)
//with natural frequency wn=1 rad/sec and xi=0.3 (underdamped),
//xi=1.5 (overdamped) and xi=0 (undamped).
//------------------------------------------------------------------

//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------
xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation
s=%s // Laplace operator
s=poly(0,'s');
wn=1 // Natural frequency wn=1 rad/sec.

// case 1 : underdamped system with xi=0.3
xi=0.3
G1=syslin('c',1/(s^2+2*xi*wn*s+wn^2))   //G1(s)=1/(s^2+0.3s+1)

// case 2 : overdamped system with xi=1.5
xi=1.5
G2=syslin('c',1/(s^2+2*xi*wn*s+wn^2))   //G2(s)=1/(s^2+1.5s+1)

// case 3 : undamped system with xi=0
xi=0
G3=syslin('c',1/(s^2+2*xi*wn*s+wn^2))   //G3(s)=1/(s^2+1)
//------------------------------------------------------------------
// Unit step response
u=1
t=0:0.1:20            // Simulation time
c1=csim('step',t,G1*u)  // Response of system G1
c2=csim('step',t,G2*u)  // Response of system G2
c3=csim('step',t,G3*u)  // Response of system G3

//plots 

plot(t,c1,t,c2,'r-',t,c3,'LineWidth',2) //Responses
plot(t,u,'--','LineWidth',1) // input signal

xgrid

//Title, labels and grid to the figure
legend('Underdamped System','overdamped System', 'Undamped System',4)
title('Responses of second-order systems' ,'fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('c(t)','fontsize',2)
